IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO_EXEC_ALL]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO_EXEC_ALL];
GO

GO
--EXEC P_EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO_EXEC_ALL
CREATE PROCEDURE P_EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO_EXEC_ALL
AS
    SET NOCOUNT ON;
    SET ANSI_WARNINGS OFF;
    DECLARE @CD_CTR INT;
    BEGIN TRY
	   DECLARE ProcParetaCurva CURSOR FAST_FORWARD FOR
		SELECT 
			DISTINCT CD_CTR 
		FROM 
			V_EST_PARAM_COMPRAS_GRUPO_CURVA_PARAMETRO_COMPRAS 
		WHERE 
			PROXIMA_REVISAO_PARETO <=GETDATE()

	   OPEN ProcParetaCurva;
	   FETCH NEXT FROM ProcParetaCurva INTO @CD_CTR;

	   WHILE @@FETCH_STATUS = 0
		  BEGIN
			 PRINT ' Grupo parametro.: ' + CONVERT(VARCHAR(5), @CD_CTR) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';

			 EXEC P_EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO @CD_CTR

			 FETCH NEXT FROM ProcParetaCurva INTO @CD_CTR;
		  END ;

	   PRINT 'Concluido.' ;
	   CLOSE ProcParetaCurva ;
	   DEALLOCATE ProcParetaCurva ;
	END TRY
    BEGIN CATCH

		CLOSE ProcParetaCurva ;
		DEALLOCATE ProcParetaCurva ;
		DECLARE @ErrorMessage VARCHAR(4000) = ERROR_MESSAGE();
		DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
		DECLARE @ErrorState INT = ERROR_STATE();

		INSERT INTO ADM_ERRO ( numero ,severidade ,estado ,rotina ,linha ,mensagem ,dtErro )
			SELECT
				ERROR_NUMBER()	  AS numero
				,@ErrorSeverity	  AS severidade
				,@ErrorState		  AS estado
				,'P_EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO_EXEC_ALL'	  AS rotina
				,ERROR_LINE()		  AS linha
				,@ErrorMessage	  AS mensagem
				,GETDATE()		  AS dtErro ;

	    RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);

    END CATCH;
    
    

